//===============================================================================================
// Provides a variety of methods to support the My CD wrapper HTML application
//
// Copyright <c> 2003 Intuit, Inc.  All rights reserved
//===============================================================================================

/*
		function init()
		{
			var f=document.getElementById("estore");
			if(!f)return;

			f.onreadystatechange=initHooks;
			f.src="https://www.shop.intuit.com/share/jhtml/secure/myacct/login.jhtml;";
		}
		
		function initHooks()
		{
			var f=document.getElementById("estore");
			if(!f)return;			
			if(f.readyState!="complete")return;
			
			var d=frames[0].document;
			var cnt=d.forms.length;
			if(cnt>0)d.forms[0].onsubmit=reportSubmit;
		}
		
		function reportSubmit()
		{
			alert("e-store form submitted");
		}
*/		

//------------------------------------------------------------------------------------------------
function _main()
	// main hook
{
	var bShowPromo = false;
	
	var args = getArgs();
	if( args.length > 1 )
	{
		bShowPromo = ( args[1] == "deluxe_promo");
	}
	
	if( !bShowPromo ) hideById("promo");
}

//------------------------------------------------------------------------------------------------
// Event handlers
//------------------------------------------------------------------------------------------------

function onAbout()
{
	showOverlay();

	setTimeout( "_onAbout()", 10 );
		// Allow overlay to display first
}

function _onAbout()
	// Show the "What's Included" dialog
{
	var dlgH = 480;
	if( screen.availHeight>500 ) dlgH = 600;

	var result = window.showModalDialog( "myCDAbout.htm", null,
		"unadorned:Yes; dialogHeight:"+dlgH+"px; dialogWidth:518px; center:Yes; help:No; resizable:No; status:No;" );

	if( result == "orderByPhone" ) _onByPhone();	
	else hideOverlay();
}
	

//---------------------------------------------------------------------------------------------
function onFAQ()
{
	showOverlay();

	setTimeout( "_onFAQ()", 10 );
		// Allow overlay to display first
}

function _onFAQ()
	// Show the "What's Included" dialog
{
	var dlgH = 480;
	if( screen.availHeight>500 ) dlgH = 600;

	window.showModalDialog( "myCDFaq.htm", null,
		"unadorned:Yes; dialogHeight:"+dlgH+"px; dialogWidth:518px; center:Yes; help:No; resizable:No; status:No;" );

	hideOverlay();
}


//---------------------------------------------------------------------------------------------
function onPurchase()
{
	showOverlay();
	setTimeout( "_onPurchase()", 10 );
		// Allow overlay to display first
}

function _onPurchase()
{
	// Get a width and height that will fit within the screen
	var availW = screen.availWidth;
	var w = availW-200;
	if( w<620 ) w=620;	
	if( w>800 ) w=800;
	
	var availH = screen.availHeight;
	var h = availH-200;
	if( h>750 ) h=750;
	
	var left = Math.floor( (availW-w)/2 );

	var opt = "resizable=yes,scrollbars=yes,status=yes,toolbar=yes,menubar=no,location=no,directories=no";
	opt += ",width="+w;
	opt += ",height="+h;
	opt += ",left="+left;
	opt += ",top=50";
	
	window.onfocus = onAppFocus;
		// Catch restore focus back to this window so we can restore focus back to
		// the eStore window if it is still open...i.e. keep it on top.
		// showModalDialog or showModelessDialog does not work...first click opens anothe window.
	
	var url = "myCDConnect.htm?"+kEStoreUrl;
	gWnd = window.open( url, "eStoreWnd", opt );	
	gWndInterval = setInterval( "onCheckWnd()", 300 );
		// Periodically check if the e-store
		// window is closed...in some cases onAppFocus() does not fire
	gWnd.focus();
}


//------------------------------------------------------------------------------------------------
function onAppFocus(bSafety)
	// Set focus back to the eStore browser window if it is still open
{
	if( !top.gWnd ) return;
	
	try
	{			
		// if( !gWnd.closed ) // has some wierd side-effect under an HTA,
									 // sometimes causes focus() call to fail
		top.gWnd.focus(); 
		if(!bSafety) setTimeout( "onAppFocus(true)", 100 ); // precaution
	}
	catch(e)
	{
		onReadyToInstall();
	}
}

//------------------------------------------------------------------------------------------------
function onCheckWnd()
{
	var bInstall = false;
	
	try
	{
		if( gWnd && gWnd.closed ) bInstall = true;
	}
	catch(e)
	{
		bInstall = true;
	}
	
	if( bInstall )
	{
		if( gWndInterval )
		{
			clearInterval(gWndInterval);
			gWndInterval = null;
		}	

		onReadyToInstall();	
	}
}

//------------------------------------------------------------------------------------------------
function onReadyToInstall()
{
	window.onfocus = "";
	gWnd = null;

	var result = window.showModalDialog( "myCDInstall.htm", null,
		"unadorned:Yes; dialogHeight:300px; dialogWidth:518px; center:Yes; help:No; resizable:No; status:No;" );

	if( result ) onInstall();
	else
	{
		hideOverlay();
		window.focus();
	}	
}

//------------------------------------------------------------------------------------------------
function onByPhone()
{
	showOverlay();
	setTimeout( "_onByPhone()", 10 );
		// Allow overlay to display first
}

function _onByPhone()
{
	var result = window.showModalDialog( "myCDPhone.htm", null,
		"unadorned:Yes; dialogHeight:300px; dialogWidth:518px; center:Yes; help:No; resizable:No; status:No;" );

	if( result )
	{
		// Write an entry into the registry indicating a preference for buy by phone
		try
		{
			var shell = new ActiveXObject("WScript.Shell");
			shell.RegWrite( kBuyMethodRegKey, "phone" );
		}	
		catch(e) {alert(e)}
			
		onInstall();
	}
	else
	{
		hideOverlay();
		window.focus();
	}	
}

//------------------------------------------------------------------------------------------------
function onReinstall()
{
	showOverlay();
	setTimeout( "onInstall()",  10 );
		// Allow overlay to display first
}
